<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class Fleet extends \Google\Model
{
  /**
   * @var string
   */
  public $membership;
  /**
   * @var string
   */
  public $membershipType;
  /**
   * @var bool
   */
  public $preRegistered;
  /**
   * @var string
   */
  public $project;

  /**
   * @param string
   */
  public function setMembership($membership)
  {
    $this->membership = $membership;
  }
  /**
   * @return string
   */
  public function getMembership()
  {
    return $this->membership;
  }
  /**
   * @param string
   */
  public function setMembershipType($membershipType)
  {
    $this->membershipType = $membershipType;
  }
  /**
   * @return string
   */
  public function getMembershipType()
  {
    return $this->membershipType;
  }
  /**
   * @param bool
   */
  public function setPreRegistered($preRegistered)
  {
    $this->preRegistered = $preRegistered;
  }
  /**
   * @return bool
   */
  public function getPreRegistered()
  {
    return $this->preRegistered;
  }
  /**
   * @param string
   */
  public function setProject($project)
  {
    $this->project = $project;
  }
  /**
   * @return string
   */
  public function getProject()
  {
    return $this->project;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Fleet::class, 'Google_Service_Container_Fleet');
